<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shipping extends Model 
{

    protected $table = 'shippings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function address()
    {
        return $this->morphOne('Address', 'owner');
    }

    public function return()
    {
        return $this->belongsTo('App\Model\Return', 'return_id');
    }

}